/*
 * UNIX shell
 *
 * S. R. Bourne
 * Bell Telephone Laboratories
 */

#include "defs.h"

/* ========	input output and file copying ======== */

void
initf(UFD fd)
{
	struct fileblk *f = standin;

	f->fdes = fd;
	f->fsiz = ((flags&(oneflg|ttyflg)) == 0? BUFSIZE: 1);
	f->fnxt = f->fend = f->fbuf;
	f->feval = 0;
	f->flin = 1;
	f->feof = FALSE;
}

int
estabf(char *s)
{
	struct fileblk *f = standin;

	f->fdes = -1;
	f->fend = length(s) + (f->fnxt = s);
	f->flin = 1;
	return f->feof = (s == 0);
}

void
push(struct fileblk *f)
{
	f->fstak = standin;
	f->feof = 0;
	f->feval = 0;
	standin = f;
}

int
pop(void)
{
	struct fileblk *f = standin;

	if (f->fstak) {
		if (f->fdes >= 0)
			close(f->fdes);
		standin = f->fstak;
		return TRUE;
	} else
		return FALSE;
}

void
chkpipe(int *pv)
{
	if (pipe(pv) < 0 || pv[INPIPE] < 0 || pv[OTPIPE] < 0)
		error(piperr);
}

int
chkopen(char *idf)
{
	int rc;

	if ((rc = open(idf, 0)) < 0)
		failed(idf, badopen);
	return rc;
}

/* renumber, actually */
void
myrename(int f1, int f2)
{
	if (f1 >= 0 && f2 >= 0 && f1 != f2) {
		close(f2);
		if (dup2(f1, f2) < 0)
			error("sh: dup2 in myrename failed");
		close(f1);
		if (f2 == 0)
			ioset |= 1;
	}
}

int
create(char *s)
{
	int rc;

	if ((rc = creat(s, 0666)) < 0)
		failed(s, badcreate);
	return rc;
}

int
tmpfil(void)
{
	itos(serial++);
	movstr(numbuf, shtmpnam);
	return create(tmpout);
}

/* set by trim */
BOOL nosubst;

void
copy(struct ionod *iop)
{
	int fd;
	char c, *ends;

	if (iop == NIL)
		return;
	copy(iop->iolst);
	ends = mactrim(iop->ioname);
	if (nosubst)
		iop->iofile &= ~IODOC;
	fd = tmpfil();
	iop->ioname = cpystak(tmpout);
	iop->iolst = iotemp;
	iotemp = iop;

	for (;;) {
		staktop = locstak();
		chkpr(NL);
		while (c = (nosubst? readc(): nextc(*ends)), !eolchar(c))
			pushstak(c);
		zerostak();
		if (eof || eq(stakbot, ends))
			break;
		pushstak(NL);
		if (write(fd, stakbot, relstak()) != relstak())
			error("error writing here document temporary file");
		setstak(0);
	}
	close(fd);
}
