/*
 * UNIX shell
 *
 * S. R. Bourne
 * Bell Telephone Laboratories
 */

#include "defs.h"

struct namnod ps2nod	= { NIL, 	NIL, 	ps2name };
struct namnod fngnod	= { NIL, 	NIL, 	fngname };
struct namnod pathnod	= { NIL, 	NIL, 	pathname };
struct namnod ifsnod	= { NIL, 	NIL, 	ifsname };
struct namnod ps1nod	= { &pathnod, 	&ps2nod, ps1name };
struct namnod homenod	= { &fngnod, 	&ifsnod, homename };
struct namnod mailnod	= { &homenod, 	&ps1nod, mailname };

struct namnod *namep = &mailnod;

static BOOL	chkid(char *);
static void	namwalk(struct namnod *np);
static char	*staknam(struct namnod *np);

/* ========	variable and string handling	======== */

int
syslook(char *w, struct sysnod syswds[])
{
	char first;
	char *s;
	struct sysnod *syscan;

	if (w == NIL)
		return 0;
	first = *w;
	for (syscan = syswds; (s = syscan->sysnam) != NIL; syscan++)
		if (first == *s && eq(w, s))
			return syscan->sysval;
	return 0;
}

void
setlist(struct argnod *arg, int xp)
{
	if (flags&exportflg)
		xp |= N_EXPORT;
	while (arg) {
		char *s = mactrim(arg->argval);

		setname(s, xp);
		arg = arg->argnxt;
		if (flags & execpr) {
			prs(s);
			if (arg)
				blank();
			else
				newline();
		}
	}
}

void
setname(char *argi, int xp)
{
	char *argscan = argi;
	struct namnod *n;

	if (letter(*argscan)) {
		while (alphanum(*argscan))
			argscan++;
		if (*argscan == '=') {
			*argscan = 0;
			n = lookup(argi);
			*argscan++ = '=';
			attrib(n, xp);
			if (xp & N_ENVNAM)
				n->namenv = n->namval = argscan;
			else
				assign(n, argscan);
			return;
		}
	}
	/* ignore it; it's probably a function */
	/* failed(argi, notid); */
}

void
replace(char **a, char *v)
{
	free(*a);
	*a = make(v);
}

void
dfault(struct namnod *n, char *v)
{
	if (n->namval == 0)
		assign(n, v);
}

void
assign(struct namnod *n, char *v)
{
	if (n->namflg & N_RDONLY)
		failed(n->namid, wtfailed);
	else
		replace(&n->namval, v);
}

int
readvar(char **names)
{
	int rc = 0, nfd;
	char c;
	struct fileblk fb;
	struct fileblk *f = &fb;
	struct namnod *n = lookup(*names++);	/* done now to avoid storage mess */
	int rel = relstak();

	push(f);
	nfd = dup(0);
	if (nfd < 0)
		perror("dup(0)");
	initf(nfd);
	if (lseek(0, 0, 1) == -1)	/* pipe or stream? */
		f->fsiz = 1;

	for (;;) {
		c = nextc(0);
		if ((*names && any(c, ifsnod.namval)) || eolchar(c)) {
			zerostak();
			assign(n, absstak(rel));
			setstak(rel);
			if (*names)
				n = lookup(*names++);
			else
				n = 0;
			if (eolchar(c))
				break;
		} else
			pushstak(c);
	}
	while (n) {
		assign(n, nullstr);
		if (*names)
			n = lookup(*names++);
		else
			n = 0;
	}

	if (eof)
		rc = 1;
	lseek(0, f->fnxt - f->fend, 1);
	pop();
	return rc;
}

void
assnum(char **p, int i)
{
	itos(i);
	replace(p, numbuf);
}

char *
make(char *v)
{
	char *p;

	if (v) {
		movstr(v, p = alloc(length(v)));
		return p;
	} else
		return 0;
}

struct namnod *
lookup(char *nam)
{
	struct namnod *nscan = namep;
	struct namnod **prev = NIL;
	int lr;

	if (!chkid(nam))
		failed(nam, notid);
	while (nscan) {
		if ((lr = strcmp(nam, nscan->namid)) == 0)
			return nscan;
		else if (lr < 0)
			prev = &nscan->namlft;
		else
			prev = &nscan->namrgt;
		nscan = *prev;
	}

	/* add name node */
	nscan = (struct namnod *)alloc(sizeof *nscan);
	nscan->namlft = nscan->namrgt = NIL;
	nscan->namid = make(nam);
	nscan->namval = 0;
	nscan->namflg = N_DEFAULT;
	nscan->namenv = 0;
	*prev = nscan;
	return nscan;
}

static BOOL
chkid(char *nam)
{
	char *cp = nam;

	if (!letter(*cp))
		return FALSE;
	else
		while (*++cp)
			if (!alphanum(*cp))
				return FALSE;
	return TRUE;
}

static void (*namfn)(struct namnod *);

void
namscan(void (*fn)(struct namnod *))
{
	namfn = fn;
	namwalk(namep);
}

static void
namwalk(struct namnod *np)
{
	if (np) {
		namwalk(np->namlft);
		(*namfn)(np);
		namwalk(np->namrgt);
	}
}

void
printnam(struct namnod *n)
{
	char *s;

	sigchk();
	if (s = n->namval) {
		prs(n->namid);
		prc('=');
		prs(s);
		newline();
	}
}

void
pushstr(char *s)
{
	do {
		pushstak(*s);
	} while (*s++);
	--staktop;
}

static char *
staknam(struct namnod *n)
{
	pushstr(n->namid);
	pushstak('=');
	pushstr(n->namval);
	return getstak(staktop + 1 - (char *)(stakbot));
}

void
exname(struct namnod *n)
{
	if (n->namflg & N_EXPORT) {
		free(n->namenv);
		n->namenv = make(n->namval);
	} else {
		free(n->namval);
		n->namval = make(n->namenv);
	}
}

void
printflg(struct namnod *n)
{
	if (n->namflg & N_EXPORT) {
		prs(export);
		blank();
	}
	if (n->namflg & N_RDONLY) {
		prs(readonly);
		blank();
	}
	if (n->namflg & (N_EXPORT | N_RDONLY)) {
		prs(n->namid);
		newline();
	}
}

void
mygetenv(void)
{
	char **e = environ;

	while (*e)
		/* scripts should not inherit IFS */
		if (strncmp(*e, "IFS=", 4) != 0)
			setname(*e++, N_ENVNAM);
}

static int namec;

void
countnam(struct namnod *n)
{
	USED(n);
	namec++;
}

static char **argnam;

void
pushnam(struct namnod *n)
{
	if (n->namval)
		*argnam++ = staknam(n);
}

char **
shsetenv(void)
{
	char **er;

	namec = 0;
	namscan(countnam);
	argnam = er = (char **)getstak((namec + 1) * sizeof(char *));
	namscan(pushnam);
	*argnam++ = NIL;
	return er;
}
