/*
 *	UNIX shell
 */

#include <stddef.h>
#include <inttypes.h>
#include <stdlib.h>
#include <assert.h>
#include <setjmp.h>
#include <signal.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/times.h>
#include <sys/wait.h>
#include <unistd.h>	/* on 9, declares lseek, etc. if after sys/types.h */
#include <fcntl.h>

#define free	shfree

#include "mac.h"
#include "mode.h"
#include "name.h"
#include "stak.h"
#include "ctype.h"

#ifdef PLAN9
void	*sbrk(uintptr_t);	/* APE's unistd.h doesn't declare sbrk */
#else
#define USED(x)		/* non-Plan-9 compilers don't have this directive */
#endif

#define CPYSIZ	512		/* buffer size for here docs */

/* error exits from various parts of shell */
#define ERROR	1
#define SYNBAD	2
#define SIGFAIL 3
#define SIGFLG	0200

/* command tree */
#define FPRS	020
#define FINT	040
#define FAMP	0100
#define FPIN	0400
#define FPOU	01000
#define FPCL	02000
#define FCMD	04000
#define COMMSK	017

#define TCOM	0
#define TPAR	1
#define TFIL	2
#define TLST	3
#define TIF	4
#define TWH	5
#define TUN	6
#define TSW	7
#define TAND	8
#define TORF	9
#define TFORK	10
#define TFOR	11

/* execute table */
#define SYSSET	1
#define SYSCD	2
#define SYSEXEC	3
#define SYSLOGIN 4
#define SYSTRAP	5
#define SYSEXIT	6
#define SYSSHFT 7
#define SYSWAIT	8
#define SYSCONT 9
#define SYSBREAK 10
#define SYSEVAL 11
#define SYSDOT	12
#define SYSRDONLY 13
#define SYSTIMES 14
#define SYSXPORT 15
#define SYSNULL 16
#define SYSREAD 17
#define SYSTST	18
#define SYSUMASK	19

/* used for input and output of shell */
#define INIO 10
#define OTIO 11

/* io nodes */
#define USERIO	10
#define IOUFD	15	/* mask for UNIX file descriptor number */
#define IODOC	16
#define IOPUT	32
#define IOAPP	64
#define IOMOV	128
#define IORDW	256
#define INPIPE	0
#define OTPIPE	1

/* arg list terminator */
#define ENDARGS	0

int voidtrash;				/* a place to void functions */
char *voidstring;

#define attrib(n,f)	((n)->namflg |= (f))
/* b must be a power of 2 */
#define round(a,b)	((((uintptr_t)(a) + (b)-1)) & ~((b)-1))
#define closepipe(x)	(close(x[INPIPE]), close(x[OTPIPE]))
#define eq(a,b)		(strcmp(a, b) == 0)
#define max(a,b)	((a)>(b)? (a): (b))

/* temp files and io */
UFD	output;
int ioset;
struct ionod *iotemp;		/* files to be deleted sometime */
struct ionod *iopend;		/* documents waiting to be read at NL */

/* substitution */
int dolc;
char	**dolv;
struct dolnod *argfor;
struct argnod *gchain;

/* string constants */
extern MSG	atline;
extern MSG	readmsg;
extern MSG	colon;
extern MSG	minus;
extern MSG	nullstr;
extern MSG	sptbnl;
extern MSG	unexpected;
extern MSG	endoffile;
extern MSG	synmsg;

/* name tree and words */
extern struct sysnod reserved[];
int wdval;
int wdnum;
struct argnod *wdarg;
int wdset;
BOOL	reserv;

/* prompting */
extern MSG	stdprompt;
extern MSG	supprompt;
extern MSG	profile;

/* built in names */
struct namnod	fngnod;
struct namnod	ifsnod;
struct namnod	homenod;
struct namnod	mailnod;
struct namnod	pathnod;
struct namnod	ps1nod;
struct namnod	ps2nod;

/* special names; defined here */
extern MSG	flagadr;
char	*cmdadr;
char	*exitadr;
char	*dolladr;
char	*pcsadr;
char	*pidadr;

extern MSG	defpath;

/* names always present */
extern MSG	mailname;
extern MSG	homename;
extern MSG	pathname;
extern MSG	fngname;
extern MSG	ifsname;
extern MSG	ps1name;
extern MSG	ps2name;

/* transput */
extern char tmpout[];
char	*shtmpnam;		/* defined here */
int serial;

struct fileblk *standin;

#define input	(standin->fdes)
#define eof	(standin->feof)

int peekc;
char	*comdiv;			/* defined here */
extern MSG	devnull;

/* flags */
#define noexec	01
#define intflg	02
#define prompt	04
#define setflg	010
#define errflg	020
#define ttyflg	040
#define forked	0100
#define oneflg	0200
#define rshflg	0400
#define waiting	01000
#define stdflg	02000
#define execpr	04000
#define readpr	010000
#define keyflg	020000
#define exportflg 040000	/* -a: export all */
int flags;

/* error exits from various parts of shell */
jmp_buf	subshell;
jmp_buf	errshell;

/* fault handling */
#define MINTRAP	0
#define MAXTRAP	32

#define TRAPSET	2
#define SIGSET	4
#define SIGMOD	8

BOOL		trapnote;
extern char *trapcom[];
extern BOOL	trapflg[];

/* name tree and words */
extern char **environ;
extern char numbuf[];
extern MSG	export;
extern MSG	readonly;

/* execflgs */
int exitval;
BOOL	execbrk;
int loopcnt;
int breakcnt;

/* messages */
extern MSG	mailmsg;
extern MSG	coredump;
extern MSG	badopt;
extern MSG	badparam;
extern MSG	badsub;
extern MSG	nospace;
extern MSG	nostack;
extern MSG	notfound;
extern MSG	badtrap;
extern MSG	baddir;
extern MSG	badshift;
extern MSG	illegal;
extern MSG	restricted;
extern MSG	execpmsg;
extern MSG	notid;
extern MSG	wtfailed;
extern MSG	badcreate;
extern MSG	piperr;
extern MSG	badopen;
extern MSG	badnum;
extern MSG	arglist;
extern MSG	txtbsy;
extern MSG	toobig;
extern MSG	badexec;
extern MSG	notfound;
extern MSG	badfile;

/* signal oddities */
#ifdef INTSIGF			/* the old world */
typedef int (*sigret_t)(int);
typedef int (*sigarg_t)(int);
#else
typedef void (*sigret_t)(int);
typedef void (*sigarg_t)(int);
#endif

/* function prototypes */
char	*alloc(uintptr_t);
int	any(char c, char *s);
void	assign(struct namnod *n, char *v);
void	assnum(char **p, int i);
void	await(int i);
void	blank(void);
int	builtin(int, char **);
char	*catpath(char *path, char *name);
int	chkopen(char *idf);
void	chkpipe(int *pv);
void	chkpr(char eor);
void	chktrap(void);
void	clearup(void);
void	clrsig(int i);
struct trenod *cmd(int sym, int flg);
void	copy(struct ionod *ioparg);
void	countnam(struct namnod *n);
int	create(char *s);
void	dfault(struct namnod *n, char *v);
void	done(void);
void	error(char *s);
int	estabf(char *s);
void	execa(char *at[]);
void	execexp(char *s, intptr_t f);
int	execute(struct trenod *argt, int execflg, int *pf1, int *pf2);
void	exitset(void);
void	exitsh(int xno);
void	exname(struct namnod *n);
int	expand(char *as, int rflg);
void	failed(char *s1, char *s2);
void	fault(int sig);
struct dolnod *freeargs(struct dolnod *blk);
int	getarg(struct comnod *ac);
char	*getpath(char *s);
void	getsig(int n);
int	gmatch(char *s, char *p);
int	ignsig(int n);
void	initf(UFD fd);
void	initio(struct ionod *iop);
void	itos(unsigned long long);
int	length(char *as);
struct namnod *lookup(char *nam);
char	*macro(char *as);
char	*mactrim(char *s);
char	*make(char *v);
void	makearg(struct argnod *);
struct trenod *makefork(int flgs, struct trenod *i);
char	*movstr(char *a, char *b);
void	mygetenv(void);
void	myrename(int, int);
void	namscan(void (*fn)(struct namnod *));
void	newline(void);
int	nextc(char);
void	oldsigs(void);
int	options(int argc, char **argv);
int	pathopen(char *path, char *name);
void	perror(char *);
int	pop(void);
void	post(int pcsid);
void	postclr(void);
void	prc(char c);
void	printflg(struct namnod *n);
void	printnam(struct namnod *n);
void	prn(long long);
void	prp(void);
void	prs(char *as);
void	prt(long t);
void	push(struct fileblk *);
void	pushnam(struct namnod *n);
int	readc(void);
int	readvar(char **names);
void	replace(char **a, char *v);
void	rmtemp(struct ionod *base);
char	**scan(int argn);
void	setargs(char *argi[]);
void	setlist(struct argnod *arg, int xp);
void	setname(char *argi, int xp);
void	settmp(void);
void	shfree(void *p);
char	**shsetenv(void);
void	sigchk(void);
void	stdsigs(void);
unsigned long stoi(char *icp);
void	subst(int in, int ot);
int	syslook(char *w, struct sysnod syswds[]);
int	tmpfil(void);
void	trim(char *at);
struct dolnod *useargs(void);
int	word(void);
