/*
 *	UNIX shell
 */

#define BYTESPERWORD	(sizeof(char *))

typedef char BOOL;
typedef int UFD;
typedef char MSG[];
typedef int PIPE[];

#define NIL	((void *)0)

#define	BUFSIZE	128
struct fileblk {
	UFD	fdes;
	unsigned flin;
	BOOL	feof;
	unsigned char fsiz;	/* big enough to hold BUFSIZE constant */
	char	*fnxt;
	char	*fend;
	char	**feval;
	struct fileblk *fstak;

	char	fbuf[BUFSIZE];
};

/* for files not used with file descriptors */
struct filehdr {
	UFD	fdes;
	unsigned flin;
	BOOL	feof;
	unsigned char fsiz;
	char	*fnxt;
	char	*fend;
	char	**feval;
	struct fileblk *fstak;

	char	_fbuf[1];
};

struct sysnod {
	char	*sysnam;
	int	sysval;
};

/* this node is a proforma for those that follow */
struct trenod {
	int	tretyp;
	struct ionod *treio;
};

/* dummy for access only */
struct argnod {
	struct argnod *argnxt;
	char	argval[1];
};

struct dolnod {
	struct dolnod *dolnxt;
	int	doluse;
	char	dolarg[1];
};

struct forknod {
	int	forktyp;
	struct ionod *forkio;
	struct trenod *forktre;
};

struct comnod {
	int	comtyp;
	struct ionod *comio;
	struct argnod *comarg;
	struct argnod *comset;
};

struct ifnod {
	int	iftyp;
	struct trenod *iftre;
	struct trenod *thtre;
	struct trenod *eltre;
};

struct whnod {
	int	whtyp;
	struct trenod *whtre;
	struct trenod *dotre;
};

struct fornod {
	int	fortyp;
	struct trenod *fortre;
	char	*fornam;
	struct comnod *forlst;
};

struct swnod {
	int	swtyp;
	char	*swarg;
	struct regnod *swlst;
};

struct regnod {
	struct argnod *regptr;
	struct trenod *regcom;
	struct regnod *regnxt;
};

struct parnod {
	int	partyp;
	struct trenod *partre;
};

struct lstnod {
	int	lsttyp;
	struct trenod *lstlef;
	struct trenod *lstrit;
};

struct ionod {
	int	iofile;
	char	*ioname;
	struct ionod *ionxt;
	struct ionod *iolst;
};

#define	FORKTYPE	(sizeof(struct forknod))
#define	COMTYPE		(sizeof(struct comnod))
#define	IFTYPE		(sizeof(struct ifnod))
#define	WHTYPE		(sizeof(struct whnod))
#define	FORTYPE		(sizeof(struct fornod))
#define	SWTYPE		(sizeof(struct swnod))
#define	REGTYPE		(sizeof(struct regnod))
#define	PARTYPE		(sizeof(struct parnod))
#define	LSTTYPE		(sizeof(struct lstnod))
#define	IOTYPE		(sizeof(struct ionod))
