/*
 *	UNIX shell
 *
 *	S. R. Bourne
 *	Bell Telephone Laboratories
 */

#include "defs.h"
#include <dirent.h>

/* globals (file name generation)
 *
 * "*" in params matches r.e ".*"
 * "?" in params matches r.e. "."
 * "[...]" in params matches character class
 * "[...a-z...]" in params matches a through z.
 *
 */

static void addg(char *as1, char *as2, char *as3);

DIR *
openqdir(char *name)
{
	char *s;
	char buf[MAXNAMLEN+1];

	/* strip 0200 quoting bits */
	strncpy(buf, name, sizeof buf - 1);
	buf[sizeof buf - 1] = 0;
	for (s = buf; *s != '\0'; s++)
		*s &= STRIP;

	/* now do normal opendir */
	return opendir(buf);
}

int
expand(char *as, int rflg)
{
	int count;
	char c;
	char *rescan = NIL, *s, *cs;
	BOOL slash, dir = 0;
	struct argnod *schain = gchain;
	DIR *dirf;
	static char entry[MAXNAMLEN+1];

	if (trapnote & SIGSET)
		return 0;

	s = cs = as;

	/* check for meta chars */
	slash = 0;
	while (!fngchar(*cs))
		if (*cs++ == 0)
			if (rflg && slash)
				break;
			else
				return 0;
		else if (*cs == '/')
			slash++;

	for (;;)
		if (cs == s) {
			s = nullstr;
			break;
		} else if (*--cs == '/') {
			*cs = 0;
			if (s == cs)
				s = "/";
			break;
		}
	if ((dirf = openqdir(*s? s: ".")) != NIL)
		dir = TRUE;
	count = 0;
	if (*cs == 0)
		*cs++ = 0200;
	if (dir) {		/* check for rescan */
		char *rs = cs;
		struct dirent *e;

		do {
			if (*rs == '/') {
				rescan = rs;
				*rs = 0;
				gchain = 0;
			}
		} while (*rs++);

		while ((e = readdir(dirf)) && (trapnote & SIGSET) == 0) {
			strncpy(entry, e->d_name, sizeof entry - 1);
			entry[sizeof entry - 1] = '\0';
			if ((entry[0] == '.' && *cs != '.'))
				if (entry[1] == 0 ||
				    entry[1] == '.' && entry[2] == 0)
					continue;
			if (gmatch(entry, cs)) {
				addg(s, entry, rescan);
				count++;
			}
		}
		closedir(dirf);

		if (rescan) {
			struct argnod *rchain = gchain;

			gchain = schain;
			if (count) {
				count = 0;
				for (; rchain; rchain = rchain->argnxt)
					count += expand(rchain->argval, 1);
			}
			*rescan = '/';
		}
	}
	for (s = as; c = *s; )
		*s++ = (c & STRIP? c: '/');
	return count;
}

int
gmatch(char *s, char *p)
{
	int scc;
	char c;

	if (scc = *s++)
		if ((scc &= STRIP) == 0)
			scc = 0200;
	switch (c = *p++) {
	case '[': {
		BOOL ok = 0;
		int lc = 077777;

		while (c = *p++) {
			if (c == ']')
				return(ok? gmatch(s, p): 0);
			else if (c == MINUS) {
				if (lc <= scc && scc <= *p++)
					ok++;
			} else
				if (scc == (lc = (c & STRIP)))
					ok++;
		}
		return 0;
		}

	default:
		if ((c & STRIP) != scc)
			return 0;

	case '?':
		return scc? gmatch(s, p): 0;

	case '*':
		if (*p == 0)
			return 1;
		--s;
		while (*s)
			if (gmatch(s++, p))
				return 1;
		return 0;

	case 0:
		return scc == 0;
	}
}

static void
addg(char *as1, char *as2, char *as3)
{
	char	*s1;
	int	c;

	staktop = locstak() + BYTESPERWORD;
	s1 = as1;
	while (c = *s1++) {
		if ((c &= STRIP) == 0) {
			pushstak('/');
			break;
		}
		pushstak(c);
	}
	s1 = as2;
	while (c = *s1++)
		pushstak(c);
	if (s1 = as3) {
		pushstak('/');
		do {
			pushstak(*++s1);
		} while (*s1 != '\0');
	}
	makearg((struct argnod *)fixstak());
}

void
makearg(struct argnod *argp)
{
	argp->argnxt = gchain;
	gchain = argp;
}
