/*
 * UNIX shell
 *
 * S. R. Bourne
 * Bell Telephone Laboratories
 */

#include <sys/types.h>
#include <sys/param.h>	/* for HZ */
#include "defs.h"	/* includes sys/types.h if not already included */

#ifndef HZ
#define	HZ 60
#endif

char numbuf[24];		/* big enough for 64 bits */

/* printing and io conversion */

void
newline(void)
{
	prc(NL);
}

void
blank(void)
{
	prc(SP);
}

void
prp(void)
{
	if ((flags & prompt) == 0 && cmdadr) {
		prs(cmdadr);
		prs(colon);
	}
}

void
prs(char *s)
{
	if (s)
		write(output, s, length(s) - 1);
}

void
prc(char c)
{
	if (c)
		write(output, &c, 1);
}

void
prt(long t)		/* t is time in clock ticks, not seconds */
{
	int hr, min, sec;

	t += HZ / 2;	/* round to nearest second */
	t /= HZ;
	sec = t % 60;
	t /= 60;
	min = t % 60;
	if (hr = t / 60) {
		prn(hr);
		prc('h');
	}
	prn(min);
	prc('m');
	prn(sec);
	prc('s');
}

void
prn(long long n)
{
	itos(n);
	prs(numbuf);
}

void
itos(unsigned long long a)
{
	char *abuf;
	char revbuf[24];

	abuf = revbuf + sizeof revbuf - 1;
	*abuf-- = '\0';
	do {
		*abuf-- = a%10 + '0';
		a /= 10;
	} while (a > 0);
	strncpy(numbuf, abuf+1, sizeof numbuf);
}

unsigned long
stoi(char *icp)
{
	long r = 0;
	char *cp;
	char c;

	for (cp = icp; (c = *cp, digit(c)) && c && r >= 0; cp++)
		r = r*10 + c-'0';
	if (r < 0 || cp == icp)
		failed(icp, badnum);
	return r;
}
