/*
 * UNIX shell
 *
 * S. R. Bourne
 * Bell Telephone Laboratories
 */

#include "defs.h"

/* ========	general purpose string handling ======== */

/* strcpy with arguments reversed and a more useful return value */
char *
movstr(char *a, char *b)
{
	while (*b++ = *a++)
		continue;
	return b-1;
}

/* simpler form of strchr with arguments reversed */
int
any(char c, char *s)
{
	char d;

	while (d = *s++)
		if (d == c)
			return TRUE;
	return FALSE;
}

/* return size of s, including terminating NUL */
int
length(char *s)
{
	return s == NIL? 0: strlen(s)+1;
}
